const express = require("express");
const mysql = require("mysql");
const https = require("https");
const fs = require("fs");
const WebSocket = require("ws");

const app = express();
app.use(express.json());

// Database configuration
const db = mysql.createConnection({
  host: "154.53.44.86", // Replace with your database host
  user: "admincp_verification", // Replace with your database username
  password: "mvXoe){C{XPt", // Replace with your database password
  database: "admincp_verification", // Replace with your database name
});

// Connect to the database
db.connect((err) => {
  if (err) {
    console.error("Database connection failed:", err.stack);
    return;
  }
  console.log("Connected to database");
});

app.post("/verify", (req, res) => {
  const { purchase_code, user_id, domain, device_id } = req.body;

  if (!purchase_code || !user_id || !device_id) {
    return res.status(400).json({
      error: "Purchase code, user ID, and device information are required",
    });
  }


  const query =
    "SELECT isActive FROM purchase_verifications WHERE purchase_code = ?";
  db.query(query, [purchase_code], (err, results) => {
    if (err) {
      console.error("Database query failed:", err.stack);
      return res.status(500).json({ error: "Internal server error" });
    }

    if (results.length > 0) {
      const isActive = results[0].isActive === 1;

      if (isActive) {
        // Insert the data into app_connections table
        const insertQuery = `
          INSERT INTO app_connections (
            purchase_code, domain, user_id, device_id
          ) 
          VALUES (?, ?, ?, ?)
        `;
        db.query(
          insertQuery,
          [
            purchase_code,
            domain,
            user_id,
            JSON.stringify(device_id), // Stringify the JSON object before inserting
          ],
          (err) => {
            if (err) {
              console.error("Failed to insert connection:", err.stack);
              return res.status(500).json({
                error: "Failed to record connection: " + err.message,
              });
            }

            res.json({
              active: true,
              message: "Connection recorded successfully",
            });
          }
        );
      } else {
        res.json({ active: false, message: "Purchase code is inactive" });
      }
    } else {
      res.json({ active: false, message: "Purchase code not found" });
    }
  });
});






// SSL configuration
const options = {
  key: fs.readFileSync("/home/verify/ssl/keys/b56a0_32bf7_95fec01a22c959d017ea222540331c75.key"), // Private key path
  cert: fs.readFileSync("/home/verify/ssl/certs/cpcontacts_verify_fluttercrafty_com_b56a0_32bf7_1740641937_861840779bbf64c9bce2e7626b9cf4dd.crt"), // Certificate path
};

// Create HTTPS server
const httpsServer = https.createServer(options, app);

// Start HTTPS server on port 447
const SSL_PORT = 447;
httpsServer.listen(SSL_PORT, () => {
  console.log(`Secure API server running on https://localhost:${SSL_PORT}`);
});

// WebSocket server for real-time updates over SSL
const wss = new WebSocket.Server({ server: httpsServer });

wss.on("connection", (ws) => {
  console.log("Client connected to WebSocket");

  // Send a welcome message
  ws.send(JSON.stringify({ message: "Welcome to WebSocket server" }));

  ws.on("close", () => {
    console.log("Client disconnected");
  });
});

// Broadcast function to send updates
function broadcastUpdate(data) {
  wss.clients.forEach((client) => {
    if (client.readyState === WebSocket.OPEN) {
      client.send(JSON.stringify(data));
    }
  });
}

// Simulate real-time updates every 10 seconds
setInterval(() => {
  broadcastUpdate({ event: "purchase_code_update", status: "updated" });
}, 10000); // Broadcast every 10 seconds
